/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged;

import net.minecraftforge.common.ForgeConfigSpec;

public class TinkersReforgedConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final CommonConfig COMMON = new CommonConfig(BUILDER);
    public static final ForgeConfigSpec config = BUILDER.build();

    public static class CommonConfig {
        public OreConfig bauxiteOre;
        public OreConfig kepuOre;
        public ForgeConfigSpec.ConfigValue<Float> adaptingModifierCap;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Bauxite Ore Worldgen").push("bauxite_ore");
            this.bauxiteOre = new BauxiteOreConfig(builder);
            builder.pop();
            builder.comment("Kepu Ore Worldgen").push("kepu_ore");
            this.kepuOre = new KepuOreConfig(builder);
            this.adaptingModifierCap = builder.comment("Default Modifier Cap for adapting").define("adaptingModifierCap", (Object)Float.valueOf(10.0f));
        }
    }

    public static class KepuOreConfig
    extends OreConfig {
        public KepuOreConfig(ForgeConfigSpec.Builder builder) {
            super(builder);
            this.enabled = builder.comment("Enable/Disable Kepu ore").define("kepuOreEnabled", true);
            this.minY = builder.comment("Min Y level").defineInRange("minY", -20, -60, 256);
            this.maxY = builder.comment("Max Y Level").defineInRange("maxY", 100, -60, 256);
            this.count = builder.comment("Ore vein count").defineInRange("veinCount", 20, 1, 40);
            this.size = builder.comment("Ore vein size").defineInRange("veinSize", 3, 1, 40);
        }
    }

    public static class BauxiteOreConfig
    extends OreConfig {
        public BauxiteOreConfig(ForgeConfigSpec.Builder builder) {
            super(builder);
            this.enabled = builder.comment("Enable/Disable Bauxite ore").define("bauxiteOreEnabled", true);
            this.minY = builder.comment("Min Y level").defineInRange("minY", -60, -60, 256);
            this.maxY = builder.comment("Max Y Level").defineInRange("maxY", 120, -60, 256);
            this.count = builder.comment("Ore vein count").defineInRange("veinCount", 80, 1, 100);
            this.size = builder.comment("Ore vein size").defineInRange("veinSize", 4, 1, 10);
        }
    }

    public static class OreConfig {
        public ForgeConfigSpec.BooleanValue enabled;
        public ForgeConfigSpec.IntValue minY;
        public ForgeConfigSpec.IntValue maxY;
        public ForgeConfigSpec.IntValue count;
        public ForgeConfigSpec.IntValue size;

        public OreConfig(ForgeConfigSpec.Builder builder) {
        }

        public boolean isEnabled() {
            return (Boolean)this.enabled.get();
        }

        public int getCount() {
            return (Integer)this.count.get();
        }

        public int getSize() {
            return (Integer)this.size.get();
        }

        public int getMaxY() {
            return (Integer)this.maxY.get();
        }

        public int getMinY() {
            return (Integer)this.minY.get();
        }
    }
}

